function [cX] = CargoPos(motT, motX, F, kin1, kin2, kin3, DDB, dyn)

% k1=kin1, k2=kin2, k3=kin3
% motor counter
nk1 = 0;
nk2 = 0;
nk3 = 0;
ndyn = 0;
nDDB = 0;
% sum of motor position
xk1 = 0;
xk2 = 0;
xk3 = 0;
xdyn = 0;
xDDB = 0;

for ii = 1:length(motT)
    switch motT(ii)
        case 1
            nk1 = nk1 + 1;
            xk1 = xk1 + motX(ii);
        case 2
            nk2 = nk2 + 1;
            xk2 = xk2 + motX(ii);
        case 3
            nk3 = nk3 + 1;
            xk3 = xk3 + motX(ii);
        case 4
            nDDB = nDDB + 1;
            xDDB = xDDB + motX(ii);
        case 5
            ndyn = ndyn + 1;
            xdyn = xdyn + motX(ii);
    end
end

if nk1 + nk2+ nk3+ nDDB + ndyn==0 % no motor binding
    cX = NaN;
    return
else
    cX = (F + kin1.stiff*xk1 + kin2.stiff*xk2 + kin3.stiff*xk3 + DDB.stiff*xDDB + dyn.stiff*xdyn)/(kin1.stiff*nk1 + kin2.stiff*nk2 + kin3.stiff*nk3 + DDB.stiff*nDDB + dyn.stiff*ndyn);
end

